---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.4
-- DDL to create packages and procedures
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: September 12, 2000 MSW
-- Date Updated: October 16, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092700 Added Change Log
-- MSW 092700 Added Header Comments
-- AHW 092700 Changed error codes for all stored procedures
-- MSW 092700 Added 'SHOW ERRORS' statement after each package creation
-- MSW 092900 Added pkg_ALKINDI_CLUSTER.sp_SEL_Clusterable_Users to select user_ids for clusterable users
-- MSW 092900 Changed pkg_ALKINDI_CLUSTER.sp_SEL_ProdEval_By_User_PC SQL statement to select -1 when a user hasn't evaluated a product
-- AHW 092900 Added pkg_ALKINDI_CLUSTER.p_SEL_AVG_PRODEVALS_BY_USER
-- AHW 092900 Added pkg_ALKINDI_CLUSTER.p_SEL_AVG_PRODEVALS_BY_PROD
-- MSW 092900 Added pkg_ALKINDI_CLUSTER.sp_SEL_Product_Cluster_Size to count the number of products in a product cluster
-- MSW 092900 Corrected pkg_ALKINDI_CLUSTER.p_SEL_AVG_PRODEVALS_BY_USER, changed o_evaluation_cursor_type to o_recommendation_cursor_type
-- MSW 092900 Corrected pkg_ALKINDI_CLUSTER.p_SEL_AVG_PRODEVALS_BY_PROD, changed o_evaluation_cursor_type to o_recommendation_cursor_type
-- MSW 092900 Added pkg_ALKINDI_CLUSTER.sp_SEL_UCID_From_UCIndex to select the User_Cluster_ID given the product_cluster_id and the user_cluster_index
-- MSW 100200 Changed output column name in pkg_ALKINDI_CLUSTER.sp_SEL_ProdEval_By_User_PC from Eval to EVALUATION_SCALE_ID
-- MSW 100200 Corrected pkg_ALKINDI_CLUSTER.sp_SEL_ProdEval_By_User_PC SQL statement added (+) to EVALUATION.USER_ID
-- MSW 100200 Added pkg_ALKINDI_CLUSTER.sp_DEL_PC_Stats_Relations to reset Product Cluster tables
-- MSW 100300 Added pkg_ALKINDI_CLUSTER.sp_CNT_UC_By_PC to count the number of user_clusters in given product_cluster
-- MSW 100300 Renamed REL_PRODUCT_CLUSTER_USER to USER_PRODUCT_CLUSTER_STAT (Table name changed)
-- MSW 100300 Renamed PRODUCT_CLUSTER_ACTIVE to PRODUCT_CLUSTER_ACTIVE_IND
-- MSW 100300 Added pkg_ALKINDI_CLUSTER.sp_SEL_ProdEval_By_PC
-- MSW 100400 Renamed USER_CLUSTER_PRODUCT_STAT to PRODUCT_USER_CLUSTER_STAT
-- MSW 100400 Renamed pkg_ALKINDI_CLUSTER.sp_SEL_UC_Prod_Stat_By_PC to sp_SEL_Prod_UC_Stat_By_PC
-- MSW 100400 Corrected pkg_ALKINDI_CLUSTER.sp_SEL_Prod_UC_Stat_By_PC, there was an error with the result set
-- MSW 100400 Changed datatype of pkg_ALKINDI_CLUSTER.sp_CNT_UC_By_PC from USER_CLUSTER.USER_CLUSTER_ID%TYPE to NUMBER
-- MSW 100400 Added pkg_ALKINDI_CLUSTER.sp_CNT_USER_By_UC
-- MSW 100400 Added pkg_ALKINDI_CLUSTER.sp_SEL_UCUserProdEval_By_PC
-- MSW 100400 Added pkg_ALKINDI_CLUSTER.sp_INS_USER_Into_UC
-- MSW 100400 Renamed pkg_ALKINDI_CLUSTER.sp_SEL_ProdEval_By_PC to sp_SEL_UserProdEval_By_PC
-- MSW 100500 Added pkg_ALKINDI_CLUSTER.sp_CNT_USER_By_UC_INDEX
-- MSW 100500 Added pkg_ALKINDI_CLUSTER.sp_DEL_USER_PC_Stat_By_PC
-- MSW 100500 Added pkg_ALKINDI_CLUSTER.sp_DEL_User_From_UC_By_PC
-- MSW 100500 Changed pkg_ALKINDI_CLUSTER.sp_INS_USER_Into_UC to prevent users in multiple user clusters in one product cluster
-- MSW 100500 Renamed pkg_ALKINDI_CLUSTER.sp_DEL_USER_PC_Stat_By_PC to sp_DEL_PROD_UC_Stat_By_PC
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
-- MSW 100900 Added pkg_ALKINDI_CLUSTER.sp_INS_UC_By_PC_UC_INDEX
-- MSW 100900 Added Column PRODUCT_CLUSTER_ID to USER_UC_STAT to enhance query performance
-- AHW 100900 Renamed "STAT" table USER_CLUSTER_MEAN_DISTANCE to USER_UC_STAT
-- AHW 100900 Renamed all "STAT" columns that contained "TOTAL" to "TOT"
-- AHW 100900 Renamed all "STAT" columns that contained "W" to "WGT"
-- AHW 100900 Renamed all "STAT" table names that contained USER_CLUSTER to UC
-- AHW 100900 Renamed all "STAT" table names that contained PRODUCT_CLUSTER to PC
-- AHW 100900 Renamed all "STAT" table names that contained PRODUCT to PROD
-- AHW 100900 Renamed all "STAT" columns that contained PRODUCT to PROD (except foreign key references)
-- AHW 100900 Renamed all "STAT" columns that contained PRODUCT_CLUSTER to PC (except foreign key references)
-- AHW 100900 Renamed all "STAT" columns that contained USER_CLUSTER to UC (except foreign key references)
-- AHW 100900 Renamed "STAT" table USER_CLUSTER_DISTANCE to USER_PROD_UC_STAT
-- AHW 101000 Renamed all "STAT" columns that contained FRACTION to FRN
-- MSW 101300 Added pkg_ALKINDI_CLUSTER.sp_SEL_AVG_EVAL_BY_PROD
-- MSW 101300 Added pkg_ALKINDI_CLUSTER.sp_SEL_PROD_AVG_EVAL_By_PC
-- AHW 101300 Added comment for stored procedures
-- MSW 101300 Added pkg_ALKINDI_CLUSTER.sp_CNT_PC
-- RCK 101400 Modified pkg_ALKINDI_CLUSTER.sp_SEL_PROD_AVG_EVAL_By_PC to only pull back evals >=1.  Also to reflect REL_CLUSTERABLE...
-- RCK 101400 Modified pkg_ALKINDI_CLUSTER.sp_SEL_UserProdEval_By_PC to reflect REL_CLUSTERABLE_PROD_CLUSTER.  Also changed DECODE to NVL
-- RCK 101400 Modified pkg_ALKINDI_CLUSTER.sp_SEL_UCUserProdEval_By_PC to reflect REL_CLUSTERABLE_PROD_CLUSTER.  Also changed DECODE to NVL
-- RCK 101400 Modified pkg_ALKINDI_CLUSTER.sp_SEL_Product_Cluster_Size to reflect REL_CLUSTERABLE_PROD_CLUSTER.
-- MSW 101500 Moved pkg_ALKINDI_CLUSTER.sp_SEL_ProdEval_By_User to pkg_ALKINDI_EVALUATION
-- MSW 101500 Moved pkg_ALKINDI_CLUSTER.sp_SEL_UserProdEval_BY_UC to an archive file (ddl_archive.txt) because it is not currently being used
-- MSW 101500 Moved pkg_ALKINDI_CLUSTER.sp_SEL_Prod_Stat_BY_UC to an archive file (ddl_archive.txt) because it is not currently being used
-- MSW 101500 Moved pkg_ALKINDI_CLUSTER.sp_SEL_Clusterable_Users to an archive file (ddl_archive.txt) because it is not currently being used
-- MSW 101500 Moved pkg_ALKINDI_CLUSTER.sp_SEL_AVG_EVAL_BY_PROD to an archive file (ddl_archive.txt) because it is not currently being used
-- MSW 101500 Modified pkg_ALKINDI_CLUSTER.sp_SEL_ProdEval_By_User_PC to reflect REL_CLUSTERABLE_PROD_CLUSTER.
-- MSW 101500 Removed subquery to select USER_CLUSTER_INDEX from pkg_ALKINDI_CLUSTER.sp_SEL_Prod_UC_Stat_By_PC because of structure change to PROD_UC_STAT
-- MSW 101500 Added "OR E.EVALUATION_SCALE_ID IS NULL" to pkg_ALKINDI_CLUSTER.sp_SEL_PROD_AVG_EVAL_By_PC
-- MSW 101500 Modified pkg_ALKINDI_CLUSTER.sp_INS_USER_Into_UC to handle EXCEPTION DUP_VAL_ON_INDEX
-- MSW 101500 Removed subquery to select USER_CLUSTER_ID from pkg_ALKINDI_CLUSTER.sp_DEL_PROD_UC_Stat_By_PC because of structure change to PROD_UC_STAT
-- MSW 101500 Removed subquery to select USER_CLUSTER_ID from pkg_ALKINDI_CLUSTER.sp_DEL_User_From_UC_By_PC because of structure change to PROD_UC_STAT
-- MSW 101500 Added pkg_ALKINDI_CLUSTER.sp_SEL_ClusterSingleUserStats
-- MSW 101500 Renamed all references to PROD_UC_STAT.PROD_EVAL_MEAN_BY_UC to PROD_UC_STAT.AVG_PROD_EVAL_BY_UC because of table structure change
-- RCK 101500 Added pkg_ALKINDI_CLUSTER.sp_SEL_BadRecsPercent
-- MSW 101700 Added pkg_ALKINDI_CLUSTER.sp_INS_Cluster_User to insert users into UC individually
-- MSW 101900 Changed pkg_ALKINDI_CLUSTER.sp_SEL_Prod_UC_Stat_By_PC to ORDER BY USER_CLUSTER_ID, PRODUCT_INDEX
-- MSW 102000 Changed pkg_ALKINDI_CLUSTER.sp_SEL_Prod_UC_Stat_By_PC, Removed columns PROD_EVAL_VARIANCE_BY_UC, FRN_OF_UC_SEEN, FRN_OF_UC_EVAL from result set, changed AVG_PROD_EVAL_BY_UC to AVG_PROD_RATING_BY_UC

---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG
---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE pkg_ALKINDI_CLUSTER
AS
  TYPE CLUSTER_cursor_type is REF CURSOR;

  PROCEDURE sp_SEL_ProdEval_By_User_PC(
	i_USER_ID 			IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_UserProdEval_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_UCUserProdEval_By_PC(							-- MSW 100400
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_Prod_UC_Stat_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT	 	CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);
	
  PROCEDURE sp_SEL_Product_Cluster_Size(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_Count_Of_Products	OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_UCID_From_UCIndex(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	o_USER_CLUSTER_ID		OUT		USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_PC_Stats_Relations(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_CNT_UC_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_COUNT_OF_UC		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_CNT_User_By_UC(
	i_USER_CLUSTER_ID		IN		REL_USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	o_COUNT_OF_User		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_INS_USER_Into_UC(
	i_USER_ID			IN		REL_USER_CLUSTER.USER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_CNT_User_By_UC_INDEX(
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_COUNT_OF_User		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_PROD_UC_Stat_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE);

  PROCEDURE sp_DEL_User_From_UC_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE);

  PROCEDURE sp_INS_UC_By_PC_UC_INDEX(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE);

  PROCEDURE sp_SEL_PROD_AVG_EVAL_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		REL_CLUSTERABLE_PROD_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type);

  PROCEDURE sp_CNT_PC(
	o_TOTAL_PC			OUT		NUMBER);

  PROCEDURE sp_DEL_UC_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE);

  PROCEDURE sp_SEL_ClusterSingleUserStats(
	i_USER_ID			IN		EVALUATION.USER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type);

  PROCEDURE sp_SEL_BadRecsPercent(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_DSCORE			IN		NUMBER,
	o_BADRECSPERCENT		OUT		NUMBER);

  PROCEDURE sp_INS_Cluster_User(
	i_USER_ID			IN		EVALUATION.USER_ID%TYPE);

END pkg_ALKINDI_CLUSTER;
/

SHOW ERRORS


-- ==========================================================================================


CREATE OR REPLACE PACKAGE BODY pkg_ALKINDI_CLUSTER
AS

  PROCEDURE sp_SEL_ProdEval_By_User_PC(						-- MSW 092900 Changed SQL statement

-- For a supplied user and product cluster, select the products and evaluations of that
-- user for products that exist in the supplied product cluster

	i_USER_ID 			IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_CLUSTER_cursor_type FOR

	SELECT REL_CLUSTERABLE_PROD_CLUSTER.PRODUCT_ID
	     , NVL(EVALUATION.EVALUATION_SCALE_ID, -1) AS EVALUATION_SCALE_ID
	  FROM REL_CLUSTERABLE_PROD_CLUSTER, EVALUATION
	 WHERE REL_CLUSTERABLE_PROD_CLUSTER.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
         AND EVALUATION.USER_ID(+) = i_USER_ID
	   AND EVALUATION.PRODUCT_ID(+) = REL_CLUSTERABLE_PROD_CLUSTER.PRODUCT_ID
    ORDER BY REL_CLUSTERABLE_PROD_CLUSTER.PRODUCT_INDEX;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6560;						-- general errors when selecting products
												-- and evaluations in that user and product cluster
		CLOSE o_CLUSTER_cursor_type;
 END sp_SEL_ProdEval_By_User_PC;

-- ==========================================================================================

  PROCEDURE sp_SEL_UserProdEval_By_PC(							-- MSW 100300

-- For a supplied product cluster, select the user, products and evaluations
-- for products that exist in the supplied product cluster

	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_CLUSTER_cursor_type FOR

	SELECT A.USER_ID
	     , A.PRODUCT_ID
	     , NVL(E.EVALUATION_SCALE_ID,-1) AS EVALUATION_SCALE_ID
	  FROM all_user_prod_comb A
	     , EVALUATION E
	     , REL_CLUSTERABLE_PROD_CLUSTER R
	 WHERE A.USER_ID = E.USER_ID(+)
	   AND A.PRODUCT_ID = E.PRODUCT_ID(+)
	   AND R.PRODUCT_ID = A.PRODUCT_ID
	   AND R.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
    ORDER BY A.USER_ID
	     , R.PRODUCT_INDEX;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;
		CLOSE o_CLUSTER_cursor_type;
 END sp_SEL_UserProdEval_By_PC;

-- ==========================================================================================

  PROCEDURE sp_SEL_UCUserProdEval_By_PC(							-- MSW 100400

-- For a supplied product cluster, select the user, products and evaluations in that user cluster
 
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_CLUSTER_cursor_type FOR

	SELECT USER_CLUSTER.USER_CLUSTER_INDEX
	     , all_user_prod_comb.USER_id
	     , all_user_prod_comb.PRODUCT_ID
	     , NVL(EVALUATION.EVALUATION_SCALE_ID,-1) AS EVALUATION_SCALE_ID
	  FROM all_user_prod_comb
	     , EVALUATION
	     , REL_USER_CLUSTER
	     , REL_CLUSTERABLE_PROD_CLUSTER
	     , USER_CLUSTER
	 WHERE all_user_prod_comb.USER_ID = EVALUATION.USER_ID(+)
	   AND all_user_prod_comb.PRODUCT_ID = EVALUATION.PRODUCT_ID(+)
	   AND all_user_prod_comb.USER_ID = REL_USER_CLUSTER.USER_ID
	   AND USER_CLUSTER.USER_CLUSTER_ID = REL_USER_CLUSTER.USER_CLUSTER_ID
	   AND USER_CLUSTER.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND REL_CLUSTERABLE_PROD_CLUSTER.PRODUCT_ID = all_user_prod_comb.PRODUCT_ID
	   AND REL_CLUSTERABLE_PROD_CLUSTER.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
    ORDER BY USER_CLUSTER.USER_CLUSTER_INDEX
	     , all_user_prod_comb.USER_ID
	     , REL_CLUSTERABLE_PROD_CLUSTER.PRODUCT_INDEX;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;
		CLOSE o_CLUSTER_cursor_type;
 END sp_SEL_UCUserProdEval_By_PC;

-- ==========================================================================================


-- For a supplied product cluster, select the mean, variance and fractions for each product and user_cluster
-- in that product cluster (genre)

-- MSW 102000 Changed pkg_ALKINDI_CLUSTER.sp_SEL_Prod_UC_Stat_By_PC, Removed columns PROD_EVAL_VARIANCE_BY_UC, FRN_OF_UC_SEEN, FRN_OF_UC_EVAL from result set

  PROCEDURE sp_SEL_Prod_UC_Stat_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT	 	CLUSTER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_CLUSTER_cursor_type FOR

	SELECT USER_CLUSTER_INDEX
	     , USER_CLUSTER_ID
	     , PRODUCT_ID
	     , AVG_PROD_RATING_BY_UC
	  FROM PROD_UC_STAT
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
    ORDER BY USER_CLUSTER_ID, PRODUCT_INDEX;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6564;						-- general errors when selecting the mean,
												-- variance and fractions for each product
												-- and user_cluster in that product cluster
		CLOSE o_CLUSTER_cursor_type;

   END sp_SEL_Prod_UC_Stat_By_PC;

-- ==========================================================================================

  PROCEDURE sp_SEL_Product_Cluster_Size(
	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_Count_Of_Products	OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(PRODUCT_ID) INTO o_Count_Of_Products
	  FROM REL_CLUSTERABLE_PROD_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;
	
   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= 6570;						-- no data is found for that product_cluster_id
	WHEN OTHERS THEN										
		o_ERROR_CODE	:= 6571;						-- general errors when selecting product_cluster_size

   END sp_SEL_Product_Cluster_Size;

-- ==========================================================================================

  PROCEDURE sp_SEL_UCID_From_UCIndex(

-- selecting user_id from the user_cluster_index

	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	o_USER_CLUSTER_ID		OUT		USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT USER_CLUSTER_ID INTO o_USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND USER_CLUSTER_INDEX = i_USER_CLUSTER_INDEX;
	
   EXCEPTION
	WHEN NO_DATA_FOUND THEN								 
		o_ERROR_CODE	:= 6572;						  -- no data is found for that user_cluster_index
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6573;						  -- general errors when selecting user_cluster_id 
												  -- from user_cluster_index

   END sp_SEL_UCID_From_UCIndex;

-- ==========================================================================================

  PROCEDURE sp_DEL_PC_Stats_Relations(
	
-- deleting user_cluster_id from PROD_UC_STAT, REL_USER_CLUSTER, INTERCLUSTER_DISTANCE, USER_PROD_UC_STAT, USER_UC_STAT,
-- USER_PC_STAT, USER_CLUSTER 

	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	DELETE 
	  FROM PROD_UC_STAT
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

	DELETE 
	  FROM REL_USER_CLUSTER
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

	DELETE 
	  FROM INTERCLUSTER_DISTANCE
	 WHERE USER_CLUSTER_ID1 IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID)
	    OR USER_CLUSTER_ID2 IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

	DELETE 
	  FROM USER_PROD_UC_STAT
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

	DELETE 
	  FROM USER_UC_STAT
	 WHERE USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);

	DELETE 
	  FROM USER_PC_STAT
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

	DELETE 
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

   END sp_DEL_PC_Stats_Relations;

-- ==========================================================================================

  PROCEDURE sp_CNT_UC_By_PC(

-- For a supplied product cluster, count user_cluster_id

	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_COUNT_OF_UC		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(USER_CLUSTER_ID) INTO o_COUNT_OF_UC
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;
	
   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= -1;
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

   END sp_CNT_UC_By_PC;

-- ==========================================================================================

  PROCEDURE sp_CNT_User_By_UC(							-- For a supplied user cluster, count the number of users

	i_USER_CLUSTER_ID		IN		REL_USER_CLUSTER.USER_CLUSTER_ID%TYPE,
	o_COUNT_OF_User		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(USER_ID) INTO o_COUNT_OF_User
	  FROM REL_USER_CLUSTER
	 WHERE USER_CLUSTER_ID = i_USER_CLUSTER_ID;
	
   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= -1;
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

   END sp_CNT_User_By_UC;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_Into_UC(							-- Insert a user_id into the user cluster

	i_USER_ID			IN		REL_USER_CLUSTER.USER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS 
   	v_USER_CLUSTER_ID NUMBER;
   BEGIN
	o_ERROR_CODE	:= 0;

	SELECT USER_CLUSTER_ID into v_USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE USER_CLUSTER_INDEX = i_USER_CLUSTER_INDEX
	   AND PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

	INSERT INTO REL_USER_CLUSTER (USER_CLUSTER_ID, USER_CLUSTER_SUBGROUP_INDEX, PRODUCT_CLUSTER_ID, USER_ID) VALUES (v_USER_CLUSTER_ID, 0, i_PRODUCT_CLUSTER_ID, i_USER_ID);

   EXCEPTION
	WHEN DUP_VAL_ON_INDEX THEN

	UPDATE REL_USER_CLUSTER
	   SET USER_CLUSTER_ID = v_USER_CLUSTER_ID
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND USER_ID = i_USER_ID;

	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

   END sp_INS_USER_Into_UC;

-- ==========================================================================================

  PROCEDURE sp_CNT_User_By_UC_INDEX(						-- For a supplied user cluster index, count the number of users

	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE,
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_COUNT_OF_User		OUT		NUMBER,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(USER_ID) INTO o_COUNT_OF_User
	  FROM REL_USER_CLUSTER
	 WHERE USER_CLUSTER_ID =
     (SELECT USER_CLUSTER_ID
	  FROM USER_CLUSTER
	 WHERE USER_CLUSTER_INDEX = i_USER_CLUSTER_INDEX
	   AND PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID);
	
   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= -1;
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;

   END sp_CNT_User_By_UC_INDEX;

-- ==========================================================================================

  PROCEDURE sp_DEL_PROD_UC_Stat_By_PC(

-- For a supplied product cluster, delete user from PROD_UC_STAT

	i_PRODUCT_CLUSTER_ID	IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE)
   IS BEGIN
	DELETE 
	  FROM PROD_UC_STAT
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

   END sp_DEL_PROD_UC_Stat_By_PC;

-- ==========================================================================================

  PROCEDURE sp_DEL_User_From_UC_By_PC(						-- For a supplied product cluster, delete user from the user cluster

	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE)

   IS BEGIN
	DELETE 
	  FROM REL_USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

   END sp_DEL_User_From_UC_By_PC;

-- ==========================================================================================

  PROCEDURE sp_INS_UC_By_PC_UC_INDEX(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_CLUSTER_INDEX	IN		USER_CLUSTER.USER_CLUSTER_INDEX%TYPE)

   IS BEGIN
	INSERT 
	  INTO USER_CLUSTER (USER_CLUSTER_ID, USER_CLUSTER_INDEX, PRODUCT_CLUSTER_ID)
	VALUES (sq_USER_CLUSTER_ID.NEXTVAL, i_USER_CLUSTER_INDEX, i_PRODUCT_CLUSTER_ID);

   END sp_INS_UC_By_PC_UC_INDEX;

-- ==========================================================================================

  PROCEDURE sp_SEL_PROD_AVG_EVAL_By_PC(						-- For a supplied product cluster, select the average evaluation rating

	i_PRODUCT_CLUSTER_ID	IN		REL_CLUSTERABLE_PROD_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type)

   IS BEGIN

	OPEN o_CLUSTER_cursor_type FOR

	SELECT R.PRODUCT_ID, NVL(AVG(E.EVALUATION_SCALE_ID),0) AS AVG_EVAL
	  FROM EVALUATION E
	     , REL_CLUSTERABLE_PROD_CLUSTER R
	 WHERE R.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND R.PRODUCT_ID = E.PRODUCT_ID(+)
	   AND (E.EVALUATION_SCALE_ID >=1 OR E.EVALUATION_SCALE_ID IS NULL)
    GROUP BY R.PRODUCT_ID, R.PRODUCT_INDEX
    ORDER BY R.PRODUCT_INDEX;

 END sp_SEL_PROD_AVG_EVAL_By_PC;

-- ==========================================================================================

  PROCEDURE sp_CNT_PC(
	o_TOTAL_PC			OUT		NUMBER)
   IS BEGIN

	SELECT COUNT(PRODUCT_CLUSTER_ID) INTO o_TOTAL_PC
	  FROM PRODUCT_CLUSTER;

   END sp_CNT_PC;

-- ==========================================================================================

  PROCEDURE sp_DEL_UC_By_PC(
	i_PRODUCT_CLUSTER_ID	IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE)
   IS BEGIN

	DELETE 
	  FROM USER_CLUSTER
	 WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

  END sp_DEL_UC_By_PC;

-- ==========================================================================================

  PROCEDURE sp_SEL_ClusterSingleUserStats(
	i_USER_ID			IN		EVALUATION.USER_ID%TYPE,
	o_CLUSTER_cursor_type	OUT		CLUSTER_cursor_type)

   IS BEGIN

	OPEN o_CLUSTER_cursor_type FOR

	SELECT S.PRODUCT_CLUSTER_ID
     	     , S.USER_CLUSTER_INDEX
	     , SUM(POWER((S.AVG_PROD_EVAL_BY_UC - E.EVALUATION_SCALE_ID),2)) as DIFF
	  FROM PROD_UC_STAT S, EVALUATION E
	 WHERE S.PRODUCT_ID IN (SELECT PRODUCT_ID FROM EVALUATION WHERE USER_ID = i_USER_ID)
	   AND S.PRODUCT_ID = E.PRODUCT_ID
	   AND E.USER_ID = i_USER_ID
	   AND E.EVALUATION_SCALE_ID >=1
    GROUP BY S.PRODUCT_CLUSTER_ID, S.USER_CLUSTER_INDEX
    ORDER BY S.PRODUCT_CLUSTER_ID, S.USER_CLUSTER_INDEX;

 END sp_SEL_ClusterSingleUserStats;

-- ==========================================================================================
-- This procedure contains two hard-coded elements:  First, the select statement assumes a threshold of 3 i.e.
-- all products with evaluations greater than or equal to three are considered good recommendations.  To modify this,
-- change the decode statements.  Second, SCORE1 is used as the scoring function column.  There will need to be several
-- changes made to this program in order to facilitate the dynamic calling of a scoring function.

  PROCEDURE sp_SEL_BadRecsPercent(
	i_PRODUCT_CLUSTER_ID		IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_DSCORE			IN		NUMBER,
	o_BADRECSPERCENT		OUT		NUMBER) IS

	TYPE T_C IS REF CURSOR;
	v_CURSOR T_C;
	v_UCID NUMBER;
	v_GOOD NUMBER(8,3);
	v_BAD NUMBER(8,3);
	v_GOODTOTAL NUMBER(8,3) := 0;
	v_BADTOTAL NUMBER(8,3) := 0;

    BEGIN

	OPEN v_CURSOR FOR
	 SELECT USER_CLUSTER_ID 
		FROM USER_CLUSTER
		WHERE PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;

	LOOP
		FETCH v_CURSOR INTO v_UCID;
		EXIT WHEN v_CURSOR%NOTFOUND;
	
	SELECT
	 SUM(DECODE(E.EVALUATION_SCALE_ID,3,1,4,1,5,1,6,1,0)), SUM(DECODE(E.EVALUATION_SCALE_ID,1,1,2,1,0))
	 INTO v_GOOD, v_BAD
	 FROM EVALUATION E, REL_USER_CLUSTER R
	  WHERE E.USER_ID = R.USER_ID
	    AND E.EVALUATION_SCALE_ID >=1
	    AND R.USER_CLUSTER_ID = v_UCID
	    AND E.PRODUCT_ID IN
	     (SELECT PRODUCT_ID
	      FROM
	      (SELECT PRODUCT_ID
	       FROM PROD_UC_STAT
	       WHERE USER_CLUSTER_ID = v_UCID
			ORDER BY SCORE1 DESC
				)
	      WHERE ROWNUM < i_DSCORE);
--ORDERBYROWNUM
	v_GOODTOTAL := v_GOODTOTAL + v_GOOD;
	v_BADTOTAL := v_BADTOTAL + v_BAD;

	END LOOP;

	CLOSE v_CURSOR;

	SELECT (v_BADTOTAL / (v_GOODTOTAL + v_BADTOTAL)) INTO o_BADRECSPERCENT FROM DUAL;

  END sp_SEL_BadRecsPercent;

-- ==========================================================================================

  PROCEDURE sp_INS_Cluster_User(
	i_USER_ID			IN		EVALUATION.USER_ID%TYPE)
  IS
	CURSOR c_PC_UC_DIFF IS
		SELECT S.PRODUCT_CLUSTER_ID
	     	     , S.USER_CLUSTER_ID
		     , SUM(POWER((S.AVG_PROD_EVAL_BY_UC - E.EVALUATION_SCALE_ID),2)) as DIFF
		  FROM PROD_UC_STAT S, EVALUATION E
		 WHERE S.PRODUCT_ID IN (SELECT PRODUCT_ID FROM EVALUATION WHERE USER_ID = i_USER_ID)
		   AND S.PRODUCT_ID = E.PRODUCT_ID
		   AND E.USER_ID = i_USER_ID
		   AND E.EVALUATION_SCALE_ID >=1
	    GROUP BY S.PRODUCT_CLUSTER_ID, S.USER_CLUSTER_ID
	    ORDER BY S.PRODUCT_CLUSTER_ID, S.USER_CLUSTER_ID;
	v_PC_UC_DIFF c_PC_UC_DIFF%ROWTYPE;
	v_PC_ID NUMBER;
	v_UC_ID NUMBER;
	v_DIFF NUMBER(8,3);
  BEGIN
	OPEN c_PC_UC_DIFF;

	FETCH c_PC_UC_DIFF INTO v_PC_UC_DIFF;
	v_PC_ID	:= v_PC_UC_DIFF.PRODUCT_CLUSTER_ID;
	v_UC_ID	:= v_PC_UC_DIFF.USER_CLUSTER_ID;
	v_DIFF	:= v_PC_UC_DIFF.DIFF;

	WHILE c_PC_UC_DIFF%FOUND
	LOOP
	  BEGIN
		IF v_PC_UC_DIFF.PRODUCT_CLUSTER_ID = v_PC_ID THEN
			IF v_PC_UC_DIFF.DIFF < v_DIFF THEN
				v_DIFF := v_PC_UC_DIFF.DIFF;
				v_UC_ID := v_PC_UC_DIFF.USER_CLUSTER_ID;
			END IF;
		ELSE
			INSERT INTO REL_USER_CLUSTER (USER_CLUSTER_ID, USER_CLUSTER_SUBGROUP_INDEX, PRODUCT_CLUSTER_ID, USER_ID)
			VALUES (v_UC_ID, 0, v_PC_ID, i_USER_ID);
			v_PC_ID := v_PC_UC_DIFF.PRODUCT_CLUSTER_ID;
			v_DIFF := v_PC_UC_DIFF.DIFF;
			v_UC_ID := v_PC_UC_DIFF.USER_CLUSTER_ID;
		END IF;

		FETCH c_PC_UC_DIFF into v_PC_UC_DIFF;

	  EXCEPTION
		WHEN DUP_VAL_ON_INDEX THEN
		UPDATE REL_USER_CLUSTER
		   SET USER_CLUSTER_ID = v_UC_ID
		 WHERE PRODUCT_CLUSTER_ID = v_PC_ID
		   AND USER_ID = i_user_id;

		v_PC_ID := v_PC_UC_DIFF.PRODUCT_CLUSTER_ID;
		v_DIFF := v_PC_UC_DIFF.DIFF;
		v_UC_ID := v_PC_UC_DIFF.USER_CLUSTER_ID;
		FETCH c_PC_UC_DIFF into v_PC_UC_DIFF;
	  END;

	END LOOP;

	INSERT INTO REL_USER_CLUSTER (USER_CLUSTER_ID, USER_CLUSTER_SUBGROUP_INDEX,PRODUCT_CLUSTER_ID, USER_ID)
	VALUES (v_UC_ID, 0, v_PC_ID, i_USER_ID);

	CLOSE c_PC_UC_DIFF;

  EXCEPTION
	WHEN DUP_VAL_ON_INDEX THEN
	UPDATE REL_USER_CLUSTER
	   SET USER_CLUSTER_ID = v_UC_ID
	 WHERE PRODUCT_CLUSTER_ID = v_PC_ID
	   AND USER_ID = i_user_id;
	
	CLOSE c_PC_UC_DIFF;

 END sp_INS_Cluster_User;

END pkg_ALKINDI_CLUSTER;
/

SHOW ERRORS
